#include "main.h"


vertex *renderSphere( sphere_s initvalues){
  int theta = 0, phi = 0, i = 0;
  float u=0.0f,v=0.0f;
  vertex *spheret;

  if( !(spheret = malloc( sizeof(vertex)*(( 64800+540*initvalues.step)/(initvalues.step*initvalues.step)) + sizeof(vertex ) ))){
    printf("Failed to allocate memory!\nexiting.\n");
    exit(0);
  }

  for( theta = 0; theta <= 180; theta += initvalues.step ){
    for( phi = 0; phi <= 360; phi += initvalues.step){
      spheret[i].x = initvalues.x0 + initvalues.radius * sin( RADIAN(theta) ) * cos( RADIAN(phi) );
      spheret[i].y = initvalues.y0 + initvalues.radius * sin( RADIAN(theta) ) * sin( RADIAN(phi) );
      spheret[i].z = initvalues.z0 + initvalues.radius * cos( RADIAN(theta) );

      spheret[i].u = (u/128.0f);
      spheret[i].v = (v/128.0f);

      u += (128.0f/(initvalues.facets));
      
      i++;
    }
    u=0.0f;
    v += (128.0f/(initvalues.facets/2));
  }

  return spheret;
}

void drawSphere( sphere_s initva, int sm){
  int i = 0, imax=0;
  int facets = initva.facets;
  triangle tmptri;
  
#ifndef CRAP
  if( sm == 1){
    glEnable(GL_TEXTURE_GEN_S);
    glEnable(GL_TEXTURE_GEN_T);
  }
  
  glBindTexture( GL_TEXTURE_2D, initva.texture[0]);
  
  /*
  glBegin( GL_QUADS);
  	glTexCoord2f( 0.0f, 1.0f ); glVertex3f( -1.0f, -1.0f, 1.0f );
	glTexCoord2f( 1.0f, 1.0f ); glVertex3f(  1.0f, -1.0f, 1.0f );
	glTexCoord2f( 1.0f, 0.0f ); glVertex3f(  1.0f,  1.0f, 1.0f );
	glTexCoord2f( 0.0f, 0.0f ); glVertex3f( -1.0f,  1.0f, 1.0f );	
  glEnd();
  */
  imax = ( ((64800+540*initva.step)/(initva.step*initva.step)) - (initva.facets+2) );
  for( i = 0; i <= imax; i++ ){

    if( i >= initva.facets ){
    tmptri.vertices[0].x = initva.vertices[i+1].x;
    tmptri.vertices[0].y = initva.vertices[i+1].y;
    tmptri.vertices[0].z = initva.vertices[i+1].z;

    tmptri.vertices[1].x = initva.vertices[i].x;
    tmptri.vertices[1].y = initva.vertices[i].y;
    tmptri.vertices[1].z = initva.vertices[i].z;

    tmptri.vertices[2].x = initva.vertices[i+facets+1].x;
    tmptri.vertices[2].y = initva.vertices[i+facets+1].y;
    tmptri.vertices[2].z = initva.vertices[i+facets+1].z;
    
    tmptri.normal = calc_normals( tmptri );
    
    glBegin( GL_TRIANGLES );
    	glNormal3f( tmptri.normal.x, tmptri.normal.y, tmptri.normal.z );
    	glTexCoord2f( initva.vertices[i+1].u, initva.vertices[i+1].v);
    	glVertex3f( tmptri.vertices[0].x, tmptri.vertices[0].y, tmptri.vertices[0].z );
    	glTexCoord2f( initva.vertices[i].u, initva.vertices[i].v);
    	glVertex3f( tmptri.vertices[1].x, tmptri.vertices[1].y, tmptri.vertices[1].z );
    	glTexCoord2f( initva.vertices[i+facets+1].u, initva.vertices[i+facets+1].v);
    	glVertex3f( tmptri.vertices[2].x, tmptri.vertices[2].y, tmptri.vertices[2].z );
    glEnd();							    

#ifdef DEBUG
    glBegin( GL_LINES );

    glColor3f( 1.0f,0.0f, 0.0f );
    glVertex3f( ((tmptri.vertices[0].x+tmptri.vertices[1].x+tmptri.vertices[2].x)/3),
		((tmptri.vertices[0].y+tmptri.vertices[1].y+tmptri.vertices[2].y)/3),
		((tmptri.vertices[0].z+tmptri.vertices[1].z+tmptri.vertices[2].z)/3));
    glVertex3f( ((tmptri.vertices[0].x+tmptri.vertices[1].x+tmptri.vertices[2].x)/3)
		+tmptri.normal.x,
		((tmptri.vertices[0].y+tmptri.vertices[1].y+tmptri.vertices[2].y)/3)
		+tmptri.normal.y,
		((tmptri.vertices[0].z+tmptri.vertices[1].z+tmptri.vertices[2].z)/3)
		+tmptri.normal.z);		
    glEnd();
    glColor3f(1.0f, 1.0f, 1.0f );
#endif
    }

    if( i <= imax-initva.facets ){
    tmptri.vertices[0].x = initva.vertices[i+1].x;
    tmptri.vertices[0].y = initva.vertices[i+1].y;
    tmptri.vertices[0].z = initva.vertices[i+1].z;

    tmptri.vertices[1].x = initva.vertices[i+facets+1].x;
    tmptri.vertices[1].y = initva.vertices[i+facets+1].y;
    tmptri.vertices[1].z = initva.vertices[i+facets+1].z;

    tmptri.vertices[2].x = initva.vertices[i+facets+2].x;
    tmptri.vertices[2].y = initva.vertices[i+facets+2].y;
    tmptri.vertices[2].z = initva.vertices[i+facets+2].z;
    
    tmptri.normal = calc_normals( tmptri );

    glColor3f(1.0f, 1.0f, 1.0f );
    glBegin( GL_TRIANGLES );
    	glNormal3f( tmptri.normal.x, tmptri.normal.y, tmptri.normal.z );
	glTexCoord2f( initva.vertices[i+1].u, initva.vertices[i+1].v );
	glVertex3f( tmptri.vertices[0].x, tmptri.vertices[0].y, tmptri.vertices[0].z );
	glTexCoord2f( initva.vertices[i+facets+1].u, initva.vertices[i+facets+1].v );
	glVertex3f( tmptri.vertices[1].x, tmptri.vertices[1].y, tmptri.vertices[1].z );
	glTexCoord2f( initva.vertices[i+facets+2].u, initva.vertices[i+facets+2].v);
	glVertex3f( tmptri.vertices[2].x, tmptri.vertices[2].y, tmptri.vertices[2].z );
    glEnd();

#ifdef DEBUG
    glBegin( GL_LINES );
    glColor3f(1.0f,0.0f, 0.0f );
    glVertex3f( ((tmptri.vertices[0].x+tmptri.vertices[1].x+tmptri.vertices[2].x)/3),
		((tmptri.vertices[0].y+tmptri.vertices[1].y+tmptri.vertices[2].y)/3),
		((tmptri.vertices[0].z+tmptri.vertices[1].z+tmptri.vertices[2].z)/3));
    glVertex3f( ((tmptri.vertices[0].x+tmptri.vertices[1].x+tmptri.vertices[2].x)/3)
		+tmptri.normal.x,
		((tmptri.vertices[0].y+tmptri.vertices[1].y+tmptri.vertices[2].y)/3)
		+tmptri.normal.y,
		((tmptri.vertices[0].z+tmptri.vertices[1].z+tmptri.vertices[2].z)/3)
		+tmptri.normal.z);
    glEnd();
    glColor3f(1.0f, 1.0f, 1.0f );
#endif
    }
  }

  if( sm == 1){
    glDisable( GL_TEXTURE_GEN_S );
    glDisable( GL_TEXTURE_GEN_T );
  }
#endif
  
#ifdef CRAP
    
  glBindTexture( GL_TEXTURE_2D, texture[0] );
  glBegin( GL_QUADS);
  glTexCoord2f( 0.0f, 1.0f ); glVertex3f( -1.0f, -1.0f, 1.0f );
  glTexCoord2f( 1.0f, 1.0f ); glVertex3f(  1.0f, -1.0f, 1.0f );
  glTexCoord2f( 1.0f, 0.0f ); glVertex3f(  1.0f,  1.0f, 1.0f );
  glTexCoord2f( 0.0f, 0.0f ); glVertex3f( -1.0f,  1.0f, 1.0f );   
  glEnd();
				      
#endif
  return;
}
					    
